/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.proxy;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.tom.storagemod.Config;
import com.tom.storagemod.StorageMod;
import com.tom.storagemod.StorageTags;
import com.tom.storagemod.gui.GuiCraftingTerminal;
import com.tom.storagemod.gui.GuiFiltered;
import com.tom.storagemod.gui.GuiLevelEmitter;
import com.tom.storagemod.gui.GuiStorageTerminal;
import com.tom.storagemod.item.ItemWirelessTerminal;
import com.tom.storagemod.model.BakedPaintedModel;
import com.tom.storagemod.proxy.IProxy;
import com.tom.storagemod.tile.TileEntityPainted;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientProxy
implements IProxy {
    @Override
    public void setup() {
    }

    @Override
    public void clientSetup() {
        ScreenManager.func_216911_a(StorageMod.storageTerminal, GuiStorageTerminal::new);
        ScreenManager.func_216911_a(StorageMod.craftingTerminalCont, GuiCraftingTerminal::new);
        ScreenManager.func_216911_a(StorageMod.filteredConatiner, GuiFiltered::new);
        ScreenManager.func_216911_a(StorageMod.levelEmitterConatiner, GuiLevelEmitter::new);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientProxy::bakeModels);
        RenderTypeLookup.setRenderLayer((Block)StorageMod.paintedTrim, e -> true);
        RenderTypeLookup.setRenderLayer((Block)StorageMod.invCableFramed, e -> true);
        RenderTypeLookup.setRenderLayer((Block)StorageMod.invProxy, e -> true);
        RenderTypeLookup.setRenderLayer((Block)StorageMod.levelEmitter, (RenderType)RenderType.func_228643_e_());
        BlockColors colors = Minecraft.func_71410_x().func_184125_al();
        colors.func_186722_a((state, world, pos, tintIndex) -> {
            if (world != null) {
                try {
                    BlockState mimicBlock = ((TileEntityPainted)world.func_175625_s(pos)).getPaintedBlockState();
                    return colors.func_228054_a_(mimicBlock, world, pos, tintIndex);
                }
                catch (Exception var8) {
                    return -1;
                }
            }
            return -1;
        }, new Block[]{StorageMod.paintedTrim, StorageMod.invCableFramed, StorageMod.invProxy});
        MinecraftForge.EVENT_BUS.addListener(ClientProxy::renderWorldLastEvent);
    }

    private static void bakeModels(ModelBakeEvent event) {
        ClientProxy.bindPaintedModel(event, (Block)StorageMod.paintedTrim);
        ClientProxy.bindPaintedModel(event, (Block)StorageMod.invCableFramed);
        ClientProxy.bindPaintedModel(event, (Block)StorageMod.invProxy);
    }

    private static void bindPaintedModel(ModelBakeEvent event, Block blockFor) {
        ResourceLocation baseLoc = blockFor.delegate.name();
        blockFor.func_176194_O().func_177619_a().forEach(st -> {
            ModelResourceLocation resLoc = BlockModelShapes.func_209553_a((ResourceLocation)baseLoc, (BlockState)st);
            event.getModelRegistry().put(resLoc, new BakedPaintedModel(blockFor, (IBakedModel)event.getModelRegistry().get(resLoc)));
        });
    }

    private static void renderWorldLastEvent(RenderWorldLastEvent evt) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        if (!ItemWirelessTerminal.isPlayerHolding((PlayerEntity)player)) {
            return;
        }
        BlockRayTraceResult lookingAt = (BlockRayTraceResult)player.func_213324_a((double)Config.wirelessRange, 0.0f, true);
        BlockState state = mc.field_71441_e.func_180495_p(lookingAt.func_216350_a());
        if (StorageTags.REMOTE_ACTIVATE.func_230235_a_((Object)state.func_177230_c())) {
            BlockPos pos = lookingAt.func_216350_a();
            Vector3d renderPos = mc.field_71460_t.func_215316_n().func_216785_c();
            Tessellator.func_178181_a().func_178180_c().func_181668_a(1, DefaultVertexFormats.field_181706_f);
            MatrixStack ms = evt.getMatrixStack();
            ms.func_227861_a_((double)pos.func_177958_n() - renderPos.field_72450_a, (double)pos.func_177956_o() - renderPos.field_72448_b, (double)pos.func_177952_p() - renderPos.field_72449_c);
            float scale = 1.01f;
            ms.func_227862_a_(scale, scale, scale);
            ms.func_227861_a_((double)-0.001f, (double)-0.001f, (double)-0.001f);
            ClientProxy.drawShape(ms, (IVertexBuilder)Tessellator.func_178181_a().func_178180_c(), state.func_235754_c_((IBlockReader)player.field_70170_p, pos), 0.0, 0.0, 0.0, 1.0f, 1.0f, 1.0f, 1.0f);
            Tessellator.func_178181_a().func_78381_a();
        }
    }

    private static void drawShape(MatrixStack matrixStackIn, IVertexBuilder bufferIn, VoxelShape shapeIn, double xIn, double yIn, double zIn, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        shapeIn.func_197754_a((p_230013_12_, p_230013_14_, p_230013_16_, p_230013_18_, p_230013_20_, p_230013_22_) -> {
            bufferIn.func_227888_a_(matrix4f, (float)(p_230013_12_ + xIn), (float)(p_230013_14_ + yIn), (float)(p_230013_16_ + zIn)).func_227885_a_(red, green, blue, alpha).func_181675_d();
            bufferIn.func_227888_a_(matrix4f, (float)(p_230013_18_ + xIn), (float)(p_230013_20_ + yIn), (float)(p_230013_22_ + zIn)).func_227885_a_(red, green, blue, alpha).func_181675_d();
        });
    }

    public static void tooltip(String key, List<ITextComponent> tooltip) {
        if (Screen.func_231173_s_()) {
            String[] sp = I18n.func_135052_a((String)("tooltip.toms_storage." + key), (Object[])new Object[0]).split("\\\\");
            for (int i = 0; i < sp.length; ++i) {
                tooltip.add((ITextComponent)new StringTextComponent(sp[i]));
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.toms_storage.hold_shift_for_info").func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY}));
        }
    }
}

